/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CCursor.h,v 1.2 1999/09/17 04:20:47 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CCursor_h	// [
#define Included_CCursor_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CCursor

class CCursor
{
	NOT_COPYABLE(CCursor)

public:
	CCursor(HCURSOR cursor = NULL);
	CCursor(HINSTANCE instance, LPCTSTR cursorName, 
		PGPBoolean shared = FALSE);
	virtual ~CCursor();

	operator HCURSOR() const {return mCursor;}
	HCURSOR	Get() const {return mCursor;}

	PGPBoolean	IsAttached();
	PGPBoolean	WeCreated() const {return mWeCreated;}

	HCURSOR	OldCursor() const {return mOldCursor;}

	void	Load(HINSTANCE instance, LPCTSTR cursorName, 
		PGPBoolean shared = FALSE);
	void	LoadCurrentCursor();

	void	SetCursor();
	void	RestoreCursor();

	static PGPBoolean	GetCursorPos(PPOINT pPoint);
	static PGPBoolean	SetCursorPos(PGPInt32 x, PGPInt32 y);
	static PGPInt32		ShowCursor(PGPBoolean show);

	void	Clear();

private:
	PGPBoolean	mWeCreated;

	HCURSOR	mCursor;
	HCURSOR	mOldCursor;
};

_PGP_END

#endif	// ] Included_CCursor_h
